/*
 * Decompiled with CFR 0.152.
 */
package moe.score.pishockzap.config;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import moe.score.pishockzap.config.PiShockApiType;
import moe.score.pishockzap.config.ShockDistribution;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PishockZapConfig {
    @NonNull
    static final String CONFIG_VERSION_KEY = "CONFIG_VERSION_DO_NOT_EDIT";
    static final int CONFIG_VERSION = 2;
    private boolean enabled = false;
    private boolean vibrationOnly = false;
    private boolean shockOnDeath = true;
    private boolean shockOnHealth = false;
    private boolean fractionalDamage = false;
    private float duration = 1.0f;
    private float maxDuration = 10.0f;
    private float vibrationThreshold = 0.0f;
    private float minDamage = 0.05f;
    private float maxDamage = 1.0f;
    private int vibrationIntensityMin = 20;
    private int vibrationIntensityMax = 100;
    private int shockIntensityMin = 5;
    private int shockIntensityMax = 60;
    private int shockIntensityDeath = 75;
    private float shockDurationDeath = 5.0f;
    @NonNull
    private ShockDistribution shockDistribution = ShockDistribution.ROUND_ROBIN;
    @NonNull
    private ShockDistribution shockDistributionDeath = ShockDistribution.ALL;
    private float debounceTime = 1.0f;
    private boolean accumulateDuration = true;
    private boolean accumulateIntensity = false;
    private boolean queueDifferent = true;
    @NonNull
    private PiShockApiType apiType = PiShockApiType.WEB_V1;
    @NonNull
    private String logIdentifier = "PiShock-Zap (Minecraft)";
    @NonNull
    private String username = "";
    @NonNull
    private String apiKey = "";
    @NonNull
    private List<String> shareCodes = List.of("BADC0DE0000");
    @NonNull
    private String serialPort = "/dev/ttyACM0";
    @NonNull
    private List<Integer> deviceIds = List.of(Integer.valueOf(12345));
    @NonNull
    private String customWebhookUrl = "";

    private boolean fieldIsListOfInteger(@NonNull Field field) {
        Objects.requireNonNull(field, "field is marked non-null but is null");
        return field.getName().equals("deviceIds");
    }

    private void setSingleConfigField(@NonNull Field field, @NonNull Object value) {
        Objects.requireNonNull(field, "field is marked non-null but is null");
        Objects.requireNonNull(value, "value is marked non-null but is null");
        try {
            Class<Object> type = field.getType();
            if (type.isAssignableFrom(ShockDistribution.class)) {
                value = ShockDistribution.valueOf((String)value);
            } else if (type.isAssignableFrom(PiShockApiType.class)) {
                value = PiShockApiType.valueOf((String)value);
            } else if ((type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Integer.TYPE)) && value instanceof Number) {
                value = ((Number)value).intValue();
            } else if ((type.isAssignableFrom(Float.class) || type.isAssignableFrom(Float.TYPE)) && value instanceof Number) {
                value = Float.valueOf(((Number)value).floatValue());
            } else if (type.isAssignableFrom(List.class) && this.fieldIsListOfInteger(field)) {
                value = ((List)value).stream().map(Number::intValue).collect(Collectors.toList());
            }
            field.set(this, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassCastException | IllegalArgumentException e) {
            System.err.printf("Config value %s is not of type %s (got %s)%n", field.getName(), field.getType().getName(), value.getClass().getName());
        }
    }

    @NonNull
    private Map<String, Object> performConfigMigrations(@NonNull Map<String, Object> config) {
        int configVersion;
        Objects.requireNonNull(config, "config is marked non-null but is null");
        Object object = config.get(CONFIG_VERSION_KEY);
        if (!(object instanceof Number)) {
            configVersion = 0;
        } else {
            Number configVersionNumber = (Number)object;
            configVersion = configVersionNumber.intValue();
        }
        if (configVersion == 2) {
            return config;
        }
        config = new HashMap<String, Object>(config);
        if (configVersion < 1) {
            object = config.get("vibrationThreshold");
            if (object instanceof Number) {
                Number vibrationThresholdInt = (Number)object;
                config.put("vibrationThreshold", Float.valueOf(vibrationThresholdInt.floatValue() * 0.05f));
            }
            if ((object = config.get("maxDamage")) instanceof Number) {
                Number maxDamageInt = (Number)object;
                config.put("maxDamage", Float.valueOf(maxDamageInt.floatValue() * 0.05f));
            }
        }
        if (configVersion < 2 && (object = config.get("localEnabled")) instanceof Boolean) {
            Boolean localEnabled = (Boolean)object;
            config.put("apiType", localEnabled != false ? PiShockApiType.SERIAL.name() : PiShockApiType.WEB_V1.name());
        }
        config.put(CONFIG_VERSION_KEY, 2);
        return config;
    }

    public void setFromConfig(@NonNull Map<String, Object> config) {
        Objects.requireNonNull(config, "config is marked non-null but is null");
        config = this.performConfigMigrations(config);
        for (Field field : this.getClass().getDeclaredFields()) {
            Object value;
            int modifiers = field.getModifiers();
            if (field.isSynthetic() || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || (value = config.get(field.getName())) == null) continue;
            this.setSingleConfigField(field, value);
        }
    }

    public void copyToConfig(@NonNull Map<String, Object> config) {
        Objects.requireNonNull(config, "config is marked non-null but is null");
        for (Field field : this.getClass().getDeclaredFields()) {
            try {
                int modifiers = field.getModifiers();
                if (field.isSynthetic() || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
                Object value = field.get(this);
                if (value instanceof Enum) {
                    Enum enumVal = (Enum)value;
                    value = enumVal.name();
                }
                config.put(field.getName(), value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        config.put(CONFIG_VERSION_KEY, 2);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isVibrationOnly() {
        return this.vibrationOnly;
    }

    public boolean isShockOnDeath() {
        return this.shockOnDeath;
    }

    public boolean isShockOnHealth() {
        return this.shockOnHealth;
    }

    public boolean isFractionalDamage() {
        return this.fractionalDamage;
    }

    public float getDuration() {
        return this.duration;
    }

    public float getMaxDuration() {
        return this.maxDuration;
    }

    public float getVibrationThreshold() {
        return this.vibrationThreshold;
    }

    public float getMinDamage() {
        return this.minDamage;
    }

    public float getMaxDamage() {
        return this.maxDamage;
    }

    public int getVibrationIntensityMin() {
        return this.vibrationIntensityMin;
    }

    public int getVibrationIntensityMax() {
        return this.vibrationIntensityMax;
    }

    public int getShockIntensityMin() {
        return this.shockIntensityMin;
    }

    public int getShockIntensityMax() {
        return this.shockIntensityMax;
    }

    public int getShockIntensityDeath() {
        return this.shockIntensityDeath;
    }

    public float getShockDurationDeath() {
        return this.shockDurationDeath;
    }

    @NonNull
    public ShockDistribution getShockDistribution() {
        return this.shockDistribution;
    }

    @NonNull
    public ShockDistribution getShockDistributionDeath() {
        return this.shockDistributionDeath;
    }

    public float getDebounceTime() {
        return this.debounceTime;
    }

    public boolean isAccumulateDuration() {
        return this.accumulateDuration;
    }

    public boolean isAccumulateIntensity() {
        return this.accumulateIntensity;
    }

    public boolean isQueueDifferent() {
        return this.queueDifferent;
    }

    @NonNull
    public PiShockApiType getApiType() {
        return this.apiType;
    }

    @NonNull
    public String getLogIdentifier() {
        return this.logIdentifier;
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    @NonNull
    public String getApiKey() {
        return this.apiKey;
    }

    @NonNull
    public List<String> getShareCodes() {
        return this.shareCodes;
    }

    @NonNull
    public String getSerialPort() {
        return this.serialPort;
    }

    @NonNull
    public List<Integer> getDeviceIds() {
        return this.deviceIds;
    }

    @NonNull
    public String getCustomWebhookUrl() {
        return this.customWebhookUrl;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setVibrationOnly(boolean vibrationOnly) {
        this.vibrationOnly = vibrationOnly;
    }

    public void setShockOnDeath(boolean shockOnDeath) {
        this.shockOnDeath = shockOnDeath;
    }

    public void setShockOnHealth(boolean shockOnHealth) {
        this.shockOnHealth = shockOnHealth;
    }

    public void setFractionalDamage(boolean fractionalDamage) {
        this.fractionalDamage = fractionalDamage;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public void setMaxDuration(float maxDuration) {
        this.maxDuration = maxDuration;
    }

    public void setVibrationThreshold(float vibrationThreshold) {
        this.vibrationThreshold = vibrationThreshold;
    }

    public void setMinDamage(float minDamage) {
        this.minDamage = minDamage;
    }

    public void setMaxDamage(float maxDamage) {
        this.maxDamage = maxDamage;
    }

    public void setVibrationIntensityMin(int vibrationIntensityMin) {
        this.vibrationIntensityMin = vibrationIntensityMin;
    }

    public void setVibrationIntensityMax(int vibrationIntensityMax) {
        this.vibrationIntensityMax = vibrationIntensityMax;
    }

    public void setShockIntensityMin(int shockIntensityMin) {
        this.shockIntensityMin = shockIntensityMin;
    }

    public void setShockIntensityMax(int shockIntensityMax) {
        this.shockIntensityMax = shockIntensityMax;
    }

    public void setShockIntensityDeath(int shockIntensityDeath) {
        this.shockIntensityDeath = shockIntensityDeath;
    }

    public void setShockDurationDeath(float shockDurationDeath) {
        this.shockDurationDeath = shockDurationDeath;
    }

    public void setShockDistribution(@NonNull ShockDistribution shockDistribution) {
        Objects.requireNonNull(shockDistribution, "shockDistribution is marked non-null but is null");
        this.shockDistribution = shockDistribution;
    }

    public void setShockDistributionDeath(@NonNull ShockDistribution shockDistributionDeath) {
        Objects.requireNonNull(shockDistributionDeath, "shockDistributionDeath is marked non-null but is null");
        this.shockDistributionDeath = shockDistributionDeath;
    }

    public void setDebounceTime(float debounceTime) {
        this.debounceTime = debounceTime;
    }

    public void setAccumulateDuration(boolean accumulateDuration) {
        this.accumulateDuration = accumulateDuration;
    }

    public void setAccumulateIntensity(boolean accumulateIntensity) {
        this.accumulateIntensity = accumulateIntensity;
    }

    public void setQueueDifferent(boolean queueDifferent) {
        this.queueDifferent = queueDifferent;
    }

    public void setApiType(@NonNull PiShockApiType apiType) {
        Objects.requireNonNull(apiType, "apiType is marked non-null but is null");
        this.apiType = apiType;
    }

    public void setLogIdentifier(@NonNull String logIdentifier) {
        Objects.requireNonNull(logIdentifier, "logIdentifier is marked non-null but is null");
        this.logIdentifier = logIdentifier;
    }

    public void setUsername(@NonNull String username) {
        Objects.requireNonNull(username, "username is marked non-null but is null");
        this.username = username;
    }

    public void setApiKey(@NonNull String apiKey) {
        Objects.requireNonNull(apiKey, "apiKey is marked non-null but is null");
        this.apiKey = apiKey;
    }

    public void setShareCodes(@NonNull List<String> shareCodes) {
        Objects.requireNonNull(shareCodes, "shareCodes is marked non-null but is null");
        this.shareCodes = shareCodes;
    }

    public void setSerialPort(@NonNull String serialPort) {
        Objects.requireNonNull(serialPort, "serialPort is marked non-null but is null");
        this.serialPort = serialPort;
    }

    public void setDeviceIds(@NonNull List<Integer> deviceIds) {
        Objects.requireNonNull(deviceIds, "deviceIds is marked non-null but is null");
        this.deviceIds = deviceIds;
    }

    public void setCustomWebhookUrl(@NonNull String customWebhookUrl) {
        Objects.requireNonNull(customWebhookUrl, "customWebhookUrl is marked non-null but is null");
        this.customWebhookUrl = customWebhookUrl;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PishockZapConfig)) {
            return false;
        }
        PishockZapConfig other = (PishockZapConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isVibrationOnly() != other.isVibrationOnly()) {
            return false;
        }
        if (this.isShockOnDeath() != other.isShockOnDeath()) {
            return false;
        }
        if (this.isShockOnHealth() != other.isShockOnHealth()) {
            return false;
        }
        if (this.isFractionalDamage() != other.isFractionalDamage()) {
            return false;
        }
        if (Float.compare(this.getDuration(), other.getDuration()) != 0) {
            return false;
        }
        if (Float.compare(this.getMaxDuration(), other.getMaxDuration()) != 0) {
            return false;
        }
        if (Float.compare(this.getVibrationThreshold(), other.getVibrationThreshold()) != 0) {
            return false;
        }
        if (Float.compare(this.getMinDamage(), other.getMinDamage()) != 0) {
            return false;
        }
        if (Float.compare(this.getMaxDamage(), other.getMaxDamage()) != 0) {
            return false;
        }
        if (this.getVibrationIntensityMin() != other.getVibrationIntensityMin()) {
            return false;
        }
        if (this.getVibrationIntensityMax() != other.getVibrationIntensityMax()) {
            return false;
        }
        if (this.getShockIntensityMin() != other.getShockIntensityMin()) {
            return false;
        }
        if (this.getShockIntensityMax() != other.getShockIntensityMax()) {
            return false;
        }
        if (this.getShockIntensityDeath() != other.getShockIntensityDeath()) {
            return false;
        }
        if (Float.compare(this.getShockDurationDeath(), other.getShockDurationDeath()) != 0) {
            return false;
        }
        if (Float.compare(this.getDebounceTime(), other.getDebounceTime()) != 0) {
            return false;
        }
        if (this.isAccumulateDuration() != other.isAccumulateDuration()) {
            return false;
        }
        if (this.isAccumulateIntensity() != other.isAccumulateIntensity()) {
            return false;
        }
        if (this.isQueueDifferent() != other.isQueueDifferent()) {
            return false;
        }
        ShockDistribution this$shockDistribution = this.getShockDistribution();
        ShockDistribution other$shockDistribution = other.getShockDistribution();
        if (this$shockDistribution == null ? other$shockDistribution != null : !((Object)((Object)this$shockDistribution)).equals((Object)other$shockDistribution)) {
            return false;
        }
        ShockDistribution this$shockDistributionDeath = this.getShockDistributionDeath();
        ShockDistribution other$shockDistributionDeath = other.getShockDistributionDeath();
        if (this$shockDistributionDeath == null ? other$shockDistributionDeath != null : !((Object)((Object)this$shockDistributionDeath)).equals((Object)other$shockDistributionDeath)) {
            return false;
        }
        PiShockApiType this$apiType = this.getApiType();
        PiShockApiType other$apiType = other.getApiType();
        if (this$apiType == null ? other$apiType != null : !((Object)((Object)this$apiType)).equals((Object)other$apiType)) {
            return false;
        }
        String this$logIdentifier = this.getLogIdentifier();
        String other$logIdentifier = other.getLogIdentifier();
        if (this$logIdentifier == null ? other$logIdentifier != null : !this$logIdentifier.equals(other$logIdentifier)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        List<String> this$shareCodes = this.getShareCodes();
        List<String> other$shareCodes = other.getShareCodes();
        if (this$shareCodes == null ? other$shareCodes != null : !((Object)this$shareCodes).equals(other$shareCodes)) {
            return false;
        }
        String this$serialPort = this.getSerialPort();
        String other$serialPort = other.getSerialPort();
        if (this$serialPort == null ? other$serialPort != null : !this$serialPort.equals(other$serialPort)) {
            return false;
        }
        List<Integer> this$deviceIds = this.getDeviceIds();
        List<Integer> other$deviceIds = other.getDeviceIds();
        if (this$deviceIds == null ? other$deviceIds != null : !((Object)this$deviceIds).equals(other$deviceIds)) {
            return false;
        }
        String this$customWebhookUrl = this.getCustomWebhookUrl();
        String other$customWebhookUrl = other.getCustomWebhookUrl();
        return !(this$customWebhookUrl == null ? other$customWebhookUrl != null : !this$customWebhookUrl.equals(other$customWebhookUrl));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof PishockZapConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isVibrationOnly() ? 79 : 97);
        result = result * 59 + (this.isShockOnDeath() ? 79 : 97);
        result = result * 59 + (this.isShockOnHealth() ? 79 : 97);
        result = result * 59 + (this.isFractionalDamage() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getDuration());
        result = result * 59 + Float.floatToIntBits(this.getMaxDuration());
        result = result * 59 + Float.floatToIntBits(this.getVibrationThreshold());
        result = result * 59 + Float.floatToIntBits(this.getMinDamage());
        result = result * 59 + Float.floatToIntBits(this.getMaxDamage());
        result = result * 59 + this.getVibrationIntensityMin();
        result = result * 59 + this.getVibrationIntensityMax();
        result = result * 59 + this.getShockIntensityMin();
        result = result * 59 + this.getShockIntensityMax();
        result = result * 59 + this.getShockIntensityDeath();
        result = result * 59 + Float.floatToIntBits(this.getShockDurationDeath());
        result = result * 59 + Float.floatToIntBits(this.getDebounceTime());
        result = result * 59 + (this.isAccumulateDuration() ? 79 : 97);
        result = result * 59 + (this.isAccumulateIntensity() ? 79 : 97);
        result = result * 59 + (this.isQueueDifferent() ? 79 : 97);
        ShockDistribution $shockDistribution = this.getShockDistribution();
        result = result * 59 + ($shockDistribution == null ? 43 : ((Object)((Object)$shockDistribution)).hashCode());
        ShockDistribution $shockDistributionDeath = this.getShockDistributionDeath();
        result = result * 59 + ($shockDistributionDeath == null ? 43 : ((Object)((Object)$shockDistributionDeath)).hashCode());
        PiShockApiType $apiType = this.getApiType();
        result = result * 59 + ($apiType == null ? 43 : ((Object)((Object)$apiType)).hashCode());
        String $logIdentifier = this.getLogIdentifier();
        result = result * 59 + ($logIdentifier == null ? 43 : $logIdentifier.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        List<String> $shareCodes = this.getShareCodes();
        result = result * 59 + ($shareCodes == null ? 43 : ((Object)$shareCodes).hashCode());
        String $serialPort = this.getSerialPort();
        result = result * 59 + ($serialPort == null ? 43 : $serialPort.hashCode());
        List<Integer> $deviceIds = this.getDeviceIds();
        result = result * 59 + ($deviceIds == null ? 43 : ((Object)$deviceIds).hashCode());
        String $customWebhookUrl = this.getCustomWebhookUrl();
        result = result * 59 + ($customWebhookUrl == null ? 43 : $customWebhookUrl.hashCode());
        return result;
    }

    @NotNull
    public String toString() {
        return "PishockZapConfig(enabled=" + this.isEnabled() + ", vibrationOnly=" + this.isVibrationOnly() + ", shockOnDeath=" + this.isShockOnDeath() + ", shockOnHealth=" + this.isShockOnHealth() + ", fractionalDamage=" + this.isFractionalDamage() + ", duration=" + this.getDuration() + ", maxDuration=" + this.getMaxDuration() + ", vibrationThreshold=" + this.getVibrationThreshold() + ", minDamage=" + this.getMinDamage() + ", maxDamage=" + this.getMaxDamage() + ", vibrationIntensityMin=" + this.getVibrationIntensityMin() + ", vibrationIntensityMax=" + this.getVibrationIntensityMax() + ", shockIntensityMin=" + this.getShockIntensityMin() + ", shockIntensityMax=" + this.getShockIntensityMax() + ", shockIntensityDeath=" + this.getShockIntensityDeath() + ", shockDurationDeath=" + this.getShockDurationDeath() + ", shockDistribution=" + String.valueOf((Object)this.getShockDistribution()) + ", shockDistributionDeath=" + String.valueOf((Object)this.getShockDistributionDeath()) + ", debounceTime=" + this.getDebounceTime() + ", accumulateDuration=" + this.isAccumulateDuration() + ", accumulateIntensity=" + this.isAccumulateIntensity() + ", queueDifferent=" + this.isQueueDifferent() + ", apiType=" + String.valueOf((Object)this.getApiType()) + ", logIdentifier=" + this.getLogIdentifier() + ", username=" + this.getUsername() + ", apiKey=" + this.getApiKey() + ", shareCodes=" + String.valueOf(this.getShareCodes()) + ", serialPort=" + this.getSerialPort() + ", deviceIds=" + String.valueOf(this.getDeviceIds()) + ", customWebhookUrl=" + this.getCustomWebhookUrl() + ")";
    }
}

